<?php
App::uses('AppController', 'Controller');

/**
 * Plans Controller
 */
class PlansController extends AppController
{
    public $layout = 'admin';

    public function beforeFilter()
    {
        parent::beforeFilter();

        if (in_array($this->request->action, array('admin_edit', 'admin_delete'))) {
            if ($this->request->is(array('post', 'put'))) {
                if ($this->Auth->user('account_type') == 'Demo') {
                    $this->Flash->set(__('This request is disabled into demo.'), array(
                        'element' => 'error'
                    ));
                    return $this->redirect($this->referer());
                }
            }
        }
    }

    public function isAuthorized($user = null)
    {
        return parent::isAuthorized($user);
    }

    public function admin_index()
    {
        $this->layout = 'admin';

        $this->paginate = array(
            //'fields' => array(),
            'limit' => 10,
            'order' => array(
                'Plan.created' => 'desc'
            )
        );

        $plans = $this->paginate('Plan');

        $this->set('plans', $plans);
        $this->set('website_title', 'All Plans');
    }

    public function admin_add()
    {
        $this->set('website_title', 'Add Plan');

        if ($this->request->is('post')) {
            $this->Plan->create();
            if ($this->Plan->save($this->request->data)) {
                $this->Flash->set(__('The Plan has been saved'), array(
                    'element' => 'success'
                ));
                return $this->redirect(array('action' => 'index'));
            } else {
                $this->Flash->set(__('The Plan could not be saved. Please, try again.'), array(
                    'element' => 'error'
                ));
            }
        }
    }

    public function admin_edit($id = null)
    {
        $this->set('website_title', 'Edit Plan');

        if (!$id) {
            throw new NotFoundException(__('Invalid plan'));
        }

        $plan = $this->Plan->findById($id);
        if (!$plan) {
            throw new NotFoundException(__('Invalid plan.'));
        }

        if ($this->request->is(array('post', 'put'))) {
            $this->Plan->id = $id;

            if ($this->Plan->save($this->request->data)) {
                $this->Flash->set('Your plan has been updated.', array(
                    'element' => 'success'
                ));
                return $this->redirect(array('action' => 'edit', $id));
            } else {
                $this->Flash->set('Unable to update your plan.', array(
                    'element' => 'error'
                ));
            }
        }

        if (!$this->request->data) {
            $this->request->data = $plan;
        }
    }

    public function admin_delete($id = null)
    {
        if (!$id) {
            throw new NotFoundException(__('Invalid Plan.'));
        }

        if (in_array($id, array(1))) {
            $this->Flash->set(__('You can\'t delete this plan.'), array(
                'element' => 'error'
            ));
            return $this->redirect(array('action' => 'index'));
        }

        if (!$this->request->is('post')) {
            throw new MethodNotAllowedException();
        }

        $plan = $this->Plan->findById($id);
        if (!$plan) {
            throw new NotFoundException(__('Invalid Plan.'));
        }

        $users = $this->Plan->User->find('count', array(
            'conditions' => array('User.plan_id' => $id)
        ));

        if ($users) {
            $this->Flash->set(__('This plans conatins users so You can\'t delete it.'), array(
                'element' => 'error'
            ));
            return $this->redirect(array('action' => 'index'));
        }

        $this->Plan->id = $id;

        if ($this->Plan->delete()) {
            $this->Flash->set(__('Plan deleted'), array(
                'element' => 'success'
            ));
            return $this->redirect(array('action' => 'index'));
        } else {
            $this->Flash->set(__('Plan was not deleted'), array(
                'element' => 'error'
            ));
        }
    }
}
